var userInput = document.getElementById("userInput"),
    outputCanvas = document.getElementById("qrcodeCanvas"),
    generateBtn = document.getElementById("generateBtn"),
    autoRun = document.getElementById("autoRun"),
    pngDownloadBtn = document.getElementById("downloadPngBtn"),
    pngCopyBtn = document.getElementById("copyPngBtn"),
    svgBtn = document.getElementById("downloadSvgBtn"),
    qrBorder = document.getElementById("qrBorder"),
    qrScale = document.getElementById("qrScale"),
    errorOutput = document.getElementById("error"),
    qrSize = document.getElementById("size"),
    QRC = qrcodegen.QrCode,
    qrcode, file, inputChanged = !1;
//chrome.i18n.getMessage
function initMsg() {
    let a = document.querySelectorAll("[data-i18n]");
    for (const b of a) b.textContent = (b.dataset.i18n)
}

function generate(a) {
	try {
		//const b = QRC.Ecc[document.querySelector("input[name='correction']:checked").value];
		qrcode = QRC.encodeText(a,QRC.Ecc['LOW']);
		//const c = parseInt(qrBorder.value),
        //    d = parseInt(qrScale.value);
		qrcode.drawCanvas(8,0, outputCanvas);
        //qrSize.textContent = `${outputCanvas.width} \u00d7 ${outputCanvas.height}`;
        inputChanged = !1
    } catch (b) {
        errorOutput.textContent = ("errorInputTooLong")
    }
}

function update() {
	let a = userInput.value.trim();
    a ? (errorOutput.textContent = "", generate(a)) : errorOutput.textContent = ("genTip3")
}

function checkAndUpdate() {
    return qrcode ? inputChanged && (update(), inputChanged) ? !1 : !0 : (errorOutput.textContent = ("genTip4"), !1)
}

function download(a) {
    checkAndUpdate() && (file || (file = document.createElement("a")), "svg" === a ? (file.download = "qrcode.svg", a = parseInt(qrBorder.value), file.href = "data:image/svg+xml," + encodeURIComponent(qrcode.toSvgString(a))) : (file.download = "qrcode.png", file.href = outputCanvas.toDataURL()), file.click())
}

function copyToClipboard() {
    checkAndUpdate() && outputCanvas.toBlob(async function(a) {
        try {
            await navigator.clipboard.write([new ClipboardItem({
                [a.type]: a
            })]), showCopyResult("copySuccess")
        } catch (b) {
            showCopyResult("copyFail"), console.error(b.name, b.message)
        }
    })
}
var copyTimeoutId;

function showCopyResult(a) {
    const b = document.getElementById(a);
    copyTimeoutId && (clearTimeout(copyTimeoutId), copyTimeoutId = null);
    b.classList.replace("d-none", "d-block");
    copyTimeoutId = setTimeout(() => {
        copyTimeoutId = null;
        b.classList.replace("d-block", "d-none")
    }, 1E3)
}
var autoRunTimer = 0;

function onInputChanged(a) {
    inputChanged = !0;
    autoRun.checked && (clearTimeout(autoRunTimer), autoRunTimer = setTimeout(update, 750))
}

function init() {
    initMsg();
    userInput.addEventListener("input", onInputChanged);
    generateBtn.addEventListener("click", update);
    document.querySelectorAll(".form-group input").forEach(b => b.addEventListener("change", update));
    pngCopyBtn.addEventListener("click", copyToClipboard);
    pngDownloadBtn.addEventListener("click", () => download("png"));
    svgBtn.addEventListener("click", () => download("svg"));
    //chrome.storage.sync.get({
    //    autoRun: !0
    //}, function(b) {
    //    autoRun.checked = b.autoRun
    //});
    autoRun.addEventListener("click", function(b) {
        chrome.storage.sync.set({
            autoRun: autoRun.checked
        })
    });
    var a = (new URL(location.href)).searchParams.get("text");
    a && (userInput.value = a, generate(a));
    if ("zh-CN" == 1) {
        a = document.querySelectorAll('a[target="_blank"]');
        for (const b of a) b.href = b.href.replace("/en/", "/zh/")
    }
}
init();