/*
 * QR Code generator library (TypeScript)
 *
 * Copyright (c) Project Nayuki. (MIT License)
 * https://www.nayuki.io/page/qr-code-generator-library
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * - The above copyright notice and this permission notice shall be included in
 *   all copies or substantial portions of the Software.
 * - The Software is provided "as is", without warranty of any kind, express or
 *   implied, including but not limited to the warranties of merchantability,
 *   fitness for a particular purpose and noninfringement. In no event shall the
 *   authors or copyright holders be liable for any claim, damages or other
 *   liability, whether in an action of contract, tort or otherwise, arising from,
 *   out of or in connection with the Software or the use or other dealings in the
 *   Software.
 */
'use strict';
var qrcodegen;
(function(l) {
    function g(b, a, c) {
        if (0 > a || 31 < a || 0 != b >>> a) throw "Value out of range";
        for (--a; 0 <= a; a--) c.push(b >>> a & 1)
    }
    class e {
        constructor(b, a, c, d) {
            this.version = b;
            this.errorCorrectionLevel = a;
            this.mask = d;
            this.modules = [];
            this.isFunction = [];
            if (b < e.MIN_VERSION || b > e.MAX_VERSION) throw "Version value out of range";
            if (-1 > d || 7 < d) throw "Mask value out of range";
            this.size = 4 * b + 17;
            b = [];
            for (a = 0; a < this.size; a++) b.push(!1);
            for (a = 0; a < this.size; a++) this.modules.push(b.slice()), this.isFunction.push(b.slice());
            this.drawFunctionPatterns();
            c = this.addEccAndInterleave(c);
            this.drawCodewords(c);
            if (-1 == d)
                for (c = 1E9, b = 0; 8 > b; b++) this.applyMask(b), this.drawFormatBits(b), a = this.getPenaltyScore(), a < c && (d = b, c = a), this.applyMask(b);
            if (0 > d || 7 < d) throw "Assertion error";
            this.mask = d;
            this.applyMask(d);
            this.drawFormatBits(d);
            this.isFunction = []
        }
        static encodeText(b, a) {
            b = l.QrSegment.makeSegments(b);
            return e.encodeSegments(b, a)
        }
        static encodeBinary(b, a) {
            b = l.QrSegment.makeBytes(b);
            return e.encodeSegments([b], a)
        }
        static encodeSegments(b, a, c = 1, d = 40, m = -1, f = !0) {
            if (!(e.MIN_VERSION <=
                    c && c <= d && d <= e.MAX_VERSION) || -1 > m || 7 < m) throw "Invalid value";
            for (;; c++) {
                const m = 8 * e.getNumDataCodewords(c, a),
                    f = h.getTotalBits(b, c);
                if (f <= m) {
                    d = f;
                    break
                }
                if (c >= d) throw "Data too long";
            }
            for (const b of [e.Ecc.MEDIUM, e.Ecc.QUARTILE, e.Ecc.HIGH]) f && d <= 8 * e.getNumDataCodewords(c, b) && (a = b);
            f = [];
            for (var k of b) {
                g(k.mode.modeBits, 4, f);
                g(k.numChars, k.mode.numCharCountBits(c), f);
                for (const a of k.getData()) f.push(a)
            }
            if (f.length != d) throw "Assertion error";
            b = 8 * e.getNumDataCodewords(c, a);
            if (f.length > b) throw "Assertion error";
            g(0, Math.min(4, b - f.length), f);
            g(0, (8 - f.length % 8) % 8, f);
            if (0 != f.length % 8) throw "Assertion error";
            for (k = 236; f.length < b; k ^= 253) g(k, 8, f);
            let n = [];
            for (; 8 * n.length < f.length;) n.push(0);
            f.forEach((a, b) => n[b >>> 3] |= a << 7 - (b & 7));
            return new e(c, a, n, m)
        }
        getModule(b, a) {
            return 0 <= b && b < this.size && 0 <= a && a < this.size && this.modules[a][b]
        }
        drawCanvas(b, a, c) {
            if (0 >= b || 0 > a) throw "Value out of range";
            var d = (this.size + 2 * a) * b;
            c.width = d;
            c.height = d;
            c = c.getContext("2d");
            for (d = -a; d < this.size + a; d++)
                for (let e = -a; e < this.size + a; e++) c.fillStyle =
                    this.getModule(e, d) ? "#000000" : "#FFFFFF", c.fillRect((e + a) * b, (d + a) * b, b, b)
        }
        toSvgString(b) {
            if (0 > b) throw "Border must be non-negative";
            let a = [];
            for (let c = 0; c < this.size; c++)
                for (let d = 0; d < this.size; d++) this.getModule(d, c) && a.push(`M${d+b},${c+b}h1v1h-1z`);
            return `<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 ${this.size+2*b} ${this.size+2*b}" stroke="none">
	<rect width="100%" height="100%" fill="#FFFFFF"/>
	<path d="${a.join(" ")}" fill="#000000"/>
</svg>
`
        }
        drawFunctionPatterns() {
            for (var b = 0; b < this.size; b++) this.setFunctionModule(6, b, 0 == b % 2), this.setFunctionModule(b, 6, 0 == b % 2);
            this.drawFinderPattern(3, 3);
            this.drawFinderPattern(this.size - 4, 3);
            this.drawFinderPattern(3, this.size - 4);
            b = this.getAlignmentPatternPositions();
            const a = b.length;
            for (let c = 0; c < a; c++)
                for (let d = 0; d < a; d++) 0 == c && 0 == d || 0 == c && d == a - 1 || c == a - 1 && 0 == d || this.drawAlignmentPattern(b[c], b[d]);
            this.drawFormatBits(0);
            this.drawVersion()
        }
        drawFormatBits(b) {
            var a = b |= this.errorCorrectionLevel.formatBits <<
                3;
            for (let b = 0; 10 > b; b++) a = a << 1 ^ 1335 * (a >>> 9);
            b = (b << 10 | a) ^ 21522;
            if (0 != b >>> 15) throw "Assertion error";
            for (a = 0; 5 >= a; a++) this.setFunctionModule(8, a, 0 != (b >>> a & 1));
            this.setFunctionModule(8, 7, 0 != (b >>> 6 & 1));
            this.setFunctionModule(8, 8, 0 != (b >>> 7 & 1));
            this.setFunctionModule(7, 8, 0 != (b >>> 8 & 1));
            for (a = 9; 15 > a; a++) this.setFunctionModule(14 - a, 8, 0 != (b >>> a & 1));
            for (a = 0; 8 > a; a++) this.setFunctionModule(this.size - 1 - a, 8, 0 != (b >>> a & 1));
            for (a = 8; 15 > a; a++) this.setFunctionModule(8, this.size - 15 + a, 0 != (b >>> a & 1));
            this.setFunctionModule(8,
                this.size - 8, !0)
        }
        drawVersion() {
            if (!(7 > this.version)) {
                var b = this.version;
                for (var a = 0; 12 > a; a++) b = b << 1 ^ 7973 * (b >>> 11);
                b |= this.version << 12;
                if (0 != b >>> 18) throw "Assertion error";
                for (a = 0; 18 > a; a++) {
                    const c = 0 != (b >>> a & 1),
                        d = this.size - 11 + a % 3,
                        e = Math.floor(a / 3);
                    this.setFunctionModule(d, e, c);
                    this.setFunctionModule(e, d, c)
                }
            }
        }
        drawFinderPattern(b, a) {
            for (let c = -4; 4 >= c; c++)
                for (let d = -4; 4 >= d; d++) {
                    const e = Math.max(Math.abs(d), Math.abs(c)),
                        f = b + d,
                        k = a + c;
                    0 <= f && f < this.size && 0 <= k && k < this.size && this.setFunctionModule(f, k, 2 != e && 4 !=
                        e)
                }
        }
        drawAlignmentPattern(b, a) {
            for (let c = -2; 2 >= c; c++)
                for (let d = -2; 2 >= d; d++) this.setFunctionModule(b + d, a + c, 1 != Math.max(Math.abs(d), Math.abs(c)))
        }
        setFunctionModule(b, a, c) {
            this.modules[a][b] = c;
            this.isFunction[a][b] = !0
        }
        addEccAndInterleave(b) {
            var a = this.version,
                c = this.errorCorrectionLevel;
            if (b.length != e.getNumDataCodewords(a, c)) throw "Invalid argument";
            const d = e.NUM_ERROR_CORRECTION_BLOCKS[c.ordinal][a],
                m = e.ECC_CODEWORDS_PER_BLOCK[c.ordinal][a];
            a = Math.floor(e.getNumRawDataModules(a) / 8);
            const f = d - a % d,
                k = Math.floor(a /
                    d);
            c = [];
            const h = e.reedSolomonComputeDivisor(m);
            for (let a = 0, g = 0; a < d; a++) {
                let d = b.slice(g, g + k - m + (a < f ? 0 : 1));
                g += d.length;
                const l = e.reedSolomonComputeRemainder(d, h);
                a < f && d.push(0);
                c.push(d.concat(l))
            }
            let g = [];
            for (let a = 0; a < c[0].length; a++) c.forEach((b, c) => {
                (a != k - m || c >= f) && g.push(b[a])
            });
            if (g.length != a) throw "Assertion error";
            return g
        }
        drawCodewords(b) {
            if (b.length != Math.floor(e.getNumRawDataModules(this.version) / 8)) throw "Invalid argument";
            let a = 0;
            for (let c = this.size - 1; 1 <= c; c -= 2) {
                6 == c && (c = 5);
                for (let d = 0; d <
                    this.size; d++)
                    for (let e = 0; 2 > e; e++) {
                        const f = c - e,
                            k = 0 == (c + 1 & 2) ? this.size - 1 - d : d;
                        !this.isFunction[k][f] && a < 8 * b.length && (this.modules[k][f] = 0 != (b[a >>> 3] >>> 7 - (a & 7) & 1), a++)
                    }
            }
            if (a != 8 * b.length) throw "Assertion error";
        }
        applyMask(b) {
            if (0 > b || 7 < b) throw "Mask value out of range";
            for (let a = 0; a < this.size; a++)
                for (let c = 0; c < this.size; c++) {
                    let d;
                    switch (b) {
                        case 0:
                            d = 0 == (c + a) % 2;
                            break;
                        case 1:
                            d = 0 == a % 2;
                            break;
                        case 2:
                            d = 0 == c % 3;
                            break;
                        case 3:
                            d = 0 == (c + a) % 3;
                            break;
                        case 4:
                            d = 0 == (Math.floor(c / 3) + Math.floor(a / 2)) % 2;
                            break;
                        case 5:
                            d = 0 == c * a %
                                2 + c * a % 3;
                            break;
                        case 6:
                            d = 0 == (c * a % 2 + c * a % 3) % 2;
                            break;
                        case 7:
                            d = 0 == ((c + a) % 2 + c * a % 3) % 2;
                            break;
                        default:
                            throw "Assertion error";
                    }!this.isFunction[a][c] && d && (this.modules[a][c] = !this.modules[a][c])
                }
        }
        getPenaltyScore() {
            let b = 0;
            for (var a = 0; a < this.size; a++) {
                var c = !1,
                    d = 0,
                    h = [0, 0, 0, 0, 0, 0, 0],
                    f = this.size;
                for (var k = 0; k < this.size; k++) this.modules[a][k] == c ? (d++, 5 == d ? b += e.PENALTY_N1 : 5 < d && b++) : (e.finderPenaltyAddHistory(d + f, h), f = 0, c || (b += this.finderPenaltyCountPatterns(h) * e.PENALTY_N3), c = this.modules[a][k], d = 1);
                b += this.finderPenaltyTerminateAndCount(c,
                    d + f, h) * e.PENALTY_N3
            }
            for (a = 0; a < this.size; a++) {
                c = !1;
                d = 0;
                h = [0, 0, 0, 0, 0, 0, 0];
                f = this.size;
                for (k = 0; k < this.size; k++) this.modules[k][a] == c ? (d++, 5 == d ? b += e.PENALTY_N1 : 5 < d && b++) : (e.finderPenaltyAddHistory(d + f, h), f = 0, c || (b += this.finderPenaltyCountPatterns(h) * e.PENALTY_N3), c = this.modules[k][a], d = 1);
                b += this.finderPenaltyTerminateAndCount(c, d + f, h) * e.PENALTY_N3
            }
            for (a = 0; a < this.size - 1; a++)
                for (c = 0; c < this.size - 1; c++) d = this.modules[a][c], d == this.modules[a][c + 1] && d == this.modules[a + 1][c] && d == this.modules[a + 1][c + 1] && (b +=
                    e.PENALTY_N2);
            a = 0;
            for (var g of this.modules) a = g.reduce((a, b) => a + (b ? 1 : 0), a);
            g = this.size * this.size;
            return b += (Math.ceil(Math.abs(20 * a - 10 * g) / g) - 1) * e.PENALTY_N4
        }
        getAlignmentPatternPositions() {
            if (1 == this.version) return [];
            {
                const b = Math.floor(this.version / 7) + 2,
                    a = 32 == this.version ? 26 : 2 * Math.ceil((this.size - 13) / (2 * b - 2));
                let c = [6];
                for (let d = this.size - 7; c.length < b; d -= a) c.splice(1, 0, d);
                return c
            }
        }
        static getNumRawDataModules(b) {
            if (b < e.MIN_VERSION || b > e.MAX_VERSION) throw "Version number out of range";
            let a = (16 * b + 128) *
                b + 64;
            if (2 <= b) {
                const c = Math.floor(b / 7) + 2;
                a -= (25 * c - 10) * c - 55;
                7 <= b && (a -= 36)
            }
            if (!(208 <= a && 29648 >= a)) throw "Assertion error";
            return a
        }
        static getNumDataCodewords(b, a) {
            return Math.floor(e.getNumRawDataModules(b) / 8) - e.ECC_CODEWORDS_PER_BLOCK[a.ordinal][b] * e.NUM_ERROR_CORRECTION_BLOCKS[a.ordinal][b]
        }
        static reedSolomonComputeDivisor(b) {
            if (1 > b || 255 < b) throw "Degree out of range";
            let a = [];
            for (var c = 0; c < b - 1; c++) a.push(0);
            a.push(1);
            c = 1;
            for (let d = 0; d < b; d++) {
                for (let b = 0; b < a.length; b++) a[b] = e.reedSolomonMultiply(a[b],
                    c), b + 1 < a.length && (a[b] ^= a[b + 1]);
                c = e.reedSolomonMultiply(c, 2)
            }
            return a
        }
        static reedSolomonComputeRemainder(b, a) {
            let c = a.map(a => 0);
            for (const d of b) {
                const b = d ^ c.shift();
                c.push(0);
                a.forEach((a, d) => c[d] ^= e.reedSolomonMultiply(a, b))
            }
            return c
        }
        static reedSolomonMultiply(b, a) {
            if (0 != b >>> 8 || 0 != a >>> 8) throw "Byte out of range";
            let c = 0;
            for (let d = 7; 0 <= d; d--) c = c << 1 ^ 285 * (c >>> 7), c ^= (a >>> d & 1) * b;
            if (0 != c >>> 8) throw "Assertion error";
            return c
        }
        finderPenaltyCountPatterns(b) {
            const a = b[1];
            if (a > 3 * this.size) throw "Assertion error";
            const c = 0 < a && b[2] == a && b[3] == 3 * a && b[4] == a && b[5] == a;
            return (c && b[0] >= 4 * a && b[6] >= a ? 1 : 0) + (c && b[6] >= 4 * a && b[0] >= a ? 1 : 0)
        }
        finderPenaltyTerminateAndCount(b, a, c) {
            b && (e.finderPenaltyAddHistory(a, c), a = 0);
            a += this.size;
            e.finderPenaltyAddHistory(a, c);
            return this.finderPenaltyCountPatterns(c)
        }
        static finderPenaltyAddHistory(b, a) {
            a.pop();
            a.unshift(b)
        }
    }
    e.MIN_VERSION = 1;
    e.MAX_VERSION = 40;
    e.PENALTY_N1 = 3;
    e.PENALTY_N2 = 3;
    e.PENALTY_N3 = 40;
    e.PENALTY_N4 = 10;
    e.ECC_CODEWORDS_PER_BLOCK = [
        [-1, 7, 10, 15, 20, 26, 18, 20, 24, 30, 18, 20, 24, 26, 30,
            22, 24, 28, 30, 28, 28, 28, 28, 30, 30, 26, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30
        ],
        [-1, 10, 16, 26, 18, 24, 16, 18, 22, 22, 26, 30, 22, 22, 24, 24, 28, 28, 26, 26, 26, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28],
        [-1, 13, 22, 18, 26, 18, 24, 18, 22, 20, 24, 28, 26, 24, 20, 30, 24, 28, 28, 26, 30, 28, 30, 30, 30, 30, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30],
        [-1, 17, 28, 22, 16, 22, 28, 26, 26, 24, 28, 24, 28, 22, 24, 24, 30, 28, 28, 26, 28, 30, 24, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30]
    ];
    e.NUM_ERROR_CORRECTION_BLOCKS = [
        [-1, 1, 1, 1, 1, 1, 2,
            2, 2, 2, 4, 4, 4, 4, 4, 6, 6, 6, 6, 7, 8, 8, 9, 9, 10, 12, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 24, 25
        ],
        [-1, 1, 1, 1, 2, 2, 4, 4, 4, 5, 5, 5, 8, 9, 9, 10, 10, 11, 13, 14, 16, 17, 17, 18, 20, 21, 23, 25, 26, 28, 29, 31, 33, 35, 37, 38, 40, 43, 45, 47, 49],
        [-1, 1, 1, 2, 2, 4, 4, 6, 6, 8, 8, 8, 10, 12, 16, 12, 17, 16, 18, 21, 20, 23, 23, 25, 27, 29, 34, 34, 35, 38, 40, 43, 45, 48, 51, 53, 56, 59, 62, 65, 68],
        [-1, 1, 1, 2, 4, 4, 4, 5, 6, 8, 8, 11, 11, 16, 16, 18, 16, 19, 21, 25, 25, 25, 34, 30, 32, 35, 37, 40, 42, 45, 48, 51, 54, 57, 60, 63, 66, 70, 74, 77, 81]
    ];
    l.QrCode = e;
    class h {
        constructor(b, a, c) {
            this.mode = b;
            this.numChars = a;
            this.bitData =
                c;
            if (0 > a) throw "Invalid argument";
            this.bitData = c.slice()
        }
        static makeBytes(b) {
            let a = [];
            for (const c of b) g(c, 8, a);
            return new h(h.Mode.BYTE, b.length, a)
        }
        static makeNumeric(b) {
            if (!this.NUMERIC_REGEX.test(b)) throw "String contains non-numeric characters";
            let a = [];
            for (let c = 0; c < b.length;) {
                const d = Math.min(b.length - c, 3);
                g(parseInt(b.substr(c, d), 10), 3 * d + 1, a);
                c += d
            }
            return new h(h.Mode.NUMERIC, b.length, a)
        }
        static makeAlphanumeric(b) {
            if (!this.ALPHANUMERIC_REGEX.test(b)) throw "String contains unencodable characters in alphanumeric mode";
            let a = [],
                c;
            for (c = 0; c + 2 <= b.length; c += 2) {
                let d = 45 * h.ALPHANUMERIC_CHARSET.indexOf(b.charAt(c));
                d += h.ALPHANUMERIC_CHARSET.indexOf(b.charAt(c + 1));
                g(d, 11, a)
            }
            c < b.length && g(h.ALPHANUMERIC_CHARSET.indexOf(b.charAt(c)), 6, a);
            return new h(h.Mode.ALPHANUMERIC, b.length, a)
        }
        static makeSegments(b) {
            return "" == b ? [] : this.NUMERIC_REGEX.test(b) ? [h.makeNumeric(b)] : this.ALPHANUMERIC_REGEX.test(b) ? [h.makeAlphanumeric(b)] : [h.makeBytes(h.toUtf8ByteArray(b))]
        }
        static makeEci(b) {
            let a = [];
            if (0 > b) throw "ECI assignment value out of range";
            if (128 > b) g(b, 8, a);
            else if (16384 > b) g(2, 2, a), g(b, 14, a);
            else if (1E6 > b) g(6, 3, a), g(b, 21, a);
            else throw "ECI assignment value out of range";
            return new h(h.Mode.ECI, 0, a)
        }
        getData() {
            return this.bitData.slice()
        }
        static getTotalBits(b, a) {
            let c = 0;
            for (const d of b) {
                b = d.mode.numCharCountBits(a);
                if (d.numChars >= 1 << b) return Infinity;
                c += 4 + b + d.bitData.length
            }
            return c
        }
        static toUtf8ByteArray(b) {
            b = encodeURI(b);
            let a = [];
            for (let c = 0; c < b.length; c++) "%" != b.charAt(c) ? a.push(b.charCodeAt(c)) : (a.push(parseInt(b.substr(c + 1, 2), 16)),
                c += 2);
            return a
        }
    }
    h.NUMERIC_REGEX = /^[0-9]*$/;
    h.ALPHANUMERIC_REGEX = /^[A-Z0-9 $%*+.\/:-]*$/;
    h.ALPHANUMERIC_CHARSET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:";
    l.QrSegment = h
})(qrcodegen || (qrcodegen = {}));
(function(l) {
    (function(g) {
        class e {
            constructor(e, b) {
                this.ordinal = e;
                this.formatBits = b
            }
        }
        e.LOW = new e(0, 1);
        e.MEDIUM = new e(1, 0);
        e.QUARTILE = new e(2, 3);
        e.HIGH = new e(3, 2);
        g.Ecc = e
    })(l.QrCode || (l.QrCode = {}))
})(qrcodegen || (qrcodegen = {}));
(function(l) {
    (function(g) {
        class e {
            constructor(e, b) {
                this.modeBits = e;
                this.numBitsCharCount = b
            }
            numCharCountBits(e) {
                return this.numBitsCharCount[Math.floor((e + 7) / 17)]
            }
        }
        e.NUMERIC = new e(1, [10, 12, 14]);
        e.ALPHANUMERIC = new e(2, [9, 11, 13]);
        e.BYTE = new e(4, [8, 16, 16]);
        e.KANJI = new e(8, [8, 10, 12]);
        e.ECI = new e(7, [0, 0, 0]);
        g.Mode = e
    })(l.QrSegment || (l.QrSegment = {}))
})(qrcodegen || (qrcodegen = {}));